# Kyoto University Channel Generator (Evaluation Eddition) V.1.0.0

Copyright (c) 2024, Kyoto University Harada Lab.

Author: Yusuke Koda, Assistant Professor at Graduate School of Informatics, Kyoto University

![](./fig/icon_48.png)

## About

Kyoto University (link-level) channel generator, a.k.a KUCG, powered by MATLAB&reg; is an interactive and intuitive platform to generate channel impulse responses for 60 GHz (millimeter wave), 95 GHz (in-between) and 105 GHz (sub-THz) bands, which are all based on real-world channel measurements conducted by the Kyoto University Harada Lab. The output file of the channel impulse response can be immediately used for sub-THz link-level simulations.


## Environment
MATLAB&reg; version above 2023b is recommended.

## Installation

1. Open "Kyoto University Channel Generator.mlappinstall" (Then, MATLAB&reg; is automatically opened.)
2. Click on "Install"
3. You can find Kyoto University Channel Generator in your APPS tab in the following icon.

![](./fig/screen_shot.png)


## Usages

1. Select a frequency band from 60 GHz, 95 GHz, and 105 GHz.
2. Select an environment from "conference room desktop," "corridor," and "office."

Note: In this evaluation edition, only the following combinations are defined.

- 60 GHz "conference room desktop"
- 60 GHz "corridor"
- 60 GHz "office"
- 95 GHz "conference room desktop"
- 105 GHz "conference room desktop"

3. Select channel sample index selection mode. "Channel sample index" means the index of statistically-possible channel samples under receivers movement at the same height of transmitter. 
- "Ramdom sample": Channel index is set randomly.
- "Set Channel Index": Channel index is set can be set by users.
4. Click on "Run Channel Generation" button.
5. Save the parameters by clicking on "Save Response Parameters" button.

## Output File Format

Output file format is .mat file (named as \<frquency\>\_\<envorinment abbreviation\>\_\<seed\>\.mat), which includes the following variables:

- ``delay_spread`` (1x1 double)：RMS delay spread (ns)
- ``azimuth_AoA_spread`` (1x1 double): RMS azimuth AoA spread (deg)
- ``K_factor`` (1x1 double) : Rician K factor (dB)
- ``ray_delays`` (1x\<changable\> double): Delay time of each arrival ray (s)
- ``ray_aoas`` (1x\<changable\> double): Azimuth AoA of each arrival ray (deg)
- ``ray_powers`` (1x\<changable\> double): Power of each arrival ray (W), which is normalized as 1 W in total.


## Acknowledgements

This project is partly supported by the commissioned research (No. JPJ012368C04201) by the National Institute of Information and Communications Technology (NICT), Japan and the Ministry of Internal Affairs and Communications in Japan (SCOPE #JPJ00595).

## References
Please find the papers listed below for model validities and channel generation.

1. (for 60 GHz) Y. Koda, N. Ohmi, H. Endo, and H. Harada, “Comprehensive 3GPP-compatible channel model for FR2-2 short-range communications for various indoor environments,” submitted for IEEE conference.
2. (for 95 GHz) Y. Koda, N. Ohmi, H. Endo, and H. Harada, "95 GHz indoor propagation measurement and statistically enhanced 3GPP channel model for sub-THz indoor short-range communications," submitted to a possible publication in IEEE. DOI: 10.36227/techrxiv.171043245.55820651/v1
3. (for 105 GHz) Coming soon.
