% link_level_simulation_skeleton.m
%
% Description:
% ----------------------------------------------------------------------
% This is a skeleton program to perform link-level simulation 
% by using a KUCG generated channel.
% ----------------------------------------------------------------------
%
% Copyright (c) 2025, Kyoto University, Digital Communications Laboratory | Harada Lab.
% 
% Users shall cite either [1] or [2] regarding this work from Kyoto University when using this software.
% [1] Y. Koda and H. Harada, “User Guide for Sub-THz Link-Level Evaluations Based on Kyoto University Channel Generator,” Techrxiv.
% [2] (Japanese) 香田優介，原田博司「[依頼講演] 統計的チャネルモデルに基づくミリ波・サブテラヘルツ帯チャネルシミュレータ ～利用方法と基本伝送特性評価事例～」信学技報，2025年6月．
% 
% Users shall cite the relevant articles from Kyoto University if KUCG-generated channel samples are used. 
% 
% The use of this software for any purposes directly associated with weapons or weapons of mass destruction is prohibited.
%
% Users are permitted to make secondary use of the software. Any copyrights or intellectual property rights arising from research conducted using this software 
% shall be retained by the user.
%
% The use of this software for the development of products and the provision or sale of services is permitted.
% 
% THE SOFTWARE IS PROVIDED “AS IS”, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
% INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. 
% IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER INANACTION OF CONTRACT, 
% TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
% 
% The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
% 
%
% Programmed by Yusuke Koda <koda@i.kyoto-u.ac.jp>

clear all

%% ************************ Initializations *******************************

% Load KUCG output
load("105ghz_cdesktop_0_generated_responses.mat")

% Define center frequency
fc = 105 * 10^9;            % Hz

% Define time resolution
tstp = 1 * 10^(-9);            % s

% Select the usage of directional antenna
directivity = "omni";


%% ******************* Run link-level simulations *************************

% Define parameters for link-level simulations

% Define number of simulation loop
num_loop = 1000;

for ii = 1:num_loop
    
    % *************** Modulation and waveform generation **************** %
    %   
    %       Code for modulation and waveform generation here
    
    
    % *********************** Apply KUCG channel ************************ %

    % Generate tapped delay line channel
    [delay_tap_list, h_list, total_power_gain] = moderation_to_tdl(ray_aoas, ray_delays, ray_powers, tstp, directivity, ii, fc);
    
    % Apply the generated channel to waveform
    waveform2 = kucg_fading(waveform, delay_tap_list, h_list, total_power_gain);

        

    % *************** Modulation and waveform generation ******************* %
    %           
    %           Code for demodulation & BER/PER calclation here
    
   
end