% kucg_fading.m
%
% Description:
% ----------------------------------------------------------------------
% This function applies fading to the input waveform generated by KUCG and
% moderation_to_tdl.m
% ----------------------------------------------------------------------
% 
% Copyright (c) 2025, Kyoto University, Digital Communications Laboratory | Harada Lab.
% 
% Users shall cite either [1] or [2] regarding this work from Kyoto University when using this software.
% [1] Y. Koda and H. Harada, “User Guide for Sub-THz Link-Level Evaluations Based on Kyoto University Channel Generator,” Techrxiv.
% [2] (Japanese) 香田優介，原田博司「[依頼講演] 統計的チャネルモデルに基づくミリ波・サブテラヘルツ帯チャネルシミュレータ ～利用方法と基本伝送特性評価事例～」信学技報，2025年6月．
% 
% Users shall cite the relevant articles from Kyoto University if KUCG-generated channel samples are used. 
% 
% The use of this software for any purposes directly associated with weapons or weapons of mass destruction is prohibited.
%
% Users are permitted to make secondary use of the software. Any copyrights or intellectual property rights arising from research conducted using this software 
% shall be retained by the user.
%
% The use of this software for the development of products and the provision or sale of services is permitted.
% 
% THE SOFTWARE IS PROVIDED “AS IS”, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
% INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. 
% IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER INANACTION OF CONTRACT, 
% TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
% 
% The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
%
% Programmed by Yusuke Koda <koda@i.kyoto-u.ac.jp>
% 

function [waveform_out] = kucg_fading(waveform, delay_tap_list, h_list, total_power_gain)

% ********************** Variables ***************************************
% Input values:
% waveform          : Original complex waveform
% delay_tap_list    : List of delay tap
% h_list            : List of channel gain for each delay tap
% total_power_gain  : Power gain due to antenna filtering (used for power normalization)

% Output values:
% waveform_out      : Output complex waveform
% **********************************************************************

% Initialization
waveform_out = zeros(1, length(waveform));

% Add delayed wave
for i = 1:length(delay_tap_list)    % Each delay tap
    
    % Create delayed waveforms
    delayed_waveform = zeros(1, length(waveform));
    delayed_waveform(delay_tap_list(i)+1:end) = waveform(1:(length(waveform)-delay_tap_list(i)));

    % Add delayed wave
    waveform_out = waveform_out + h_list(i) .* delayed_waveform;
end

% Normalize power
waveform_out = waveform_out ./ sqrt(total_power_gain);